<?php
function categorizeQuestion($question) {
    $faq_keywords = ['what', 'how', 'who', 'where', 'when', 'why'];
    $tech_keywords = ['install', 'setup', 'error', 'debug', 'configuration', 'API'];
    $general_keywords = ['tell', 'define', 'explain', 'meaning'];

    $question_lower = strtolower($question);

    if (preg_match('/\b(' . implode('|', $faq_keywords) . ')\b/', $question_lower)) {
        return 'FAQ';
    } elseif (preg_match('/\b(' . implode('|', $tech_keywords) . ')\b/', $question_lower)) {
        return 'Tech';
    } elseif (preg_match('/\b(' . implode('|', $general_keywords) . ')\b/', $question_lower)) {
        return 'General';
    } else {
        return 'General';
    }
}
?>
