<?php
require_once 'config.php';
require_once 'functions.php';

// Initialize game functions
$game = new GameFunctions();

// Get updates from Telegram
function getUpdates($offset = null) {
    $url = TELEGRAM_API_URL . '/getUpdates';
    if ($offset) {
        $url .= '?offset=' . $offset;
    }
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

// Send message function
function sendMessage($chat_id, $text) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text
    ];
    
    $ch = curl_init(TELEGRAM_API_URL . '/sendMessage');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}

// Main bot loop
function runBot() {
    $offset = null;
    
    while (true) {
        $updates = getUpdates($offset);
        
        if (isset($updates['result']) && !empty($updates['result'])) {
            foreach ($updates['result'] as $update) {
                if (isset($update['message'])) {
                    $message = $update['message'];
                    $chat_id = $message['chat']['id'];
                    $username = $message['from']['username'] ?? 'Unknown';
                    $text = $message['text'] ?? '';
                    
                    // Create user if they don't exist
                    if (!$game->getUser($chat_id)) {
                        $game->createUser($chat_id, $username);
                    }
                    
                    // Handle commands
                    switch ($text) {
                        case '/start':
                            $response = "Welcome to Rich Animals Game!\n";
                            $response .= "Use /balance to check your balance\n";
                            $response .= "Use /claim to get daily reward\n";
                            sendMessage($chat_id, $response);
                            break;
                            
                        case '/balance':
                            $user = $game->getUser($chat_id);
                            $response = "Your balance: $" . number_format($user['balance'], 2);
                            sendMessage($chat_id, $response);
                            break;
                            
                        case '/claim':
                            if ($game->canClaim($chat_id)) {
                                $game->updateBalance($chat_id, 100);
                                $game->updateLastClaim($chat_id);
                                $user = $game->getUser($chat_id);
                                $response = "You claimed your daily reward of $100!\n";
                                $response .= "Your new balance: $" . number_format($user['balance'], 2);
                                sendMessage($chat_id, $response);
                            } else {
                                sendMessage($chat_id, "You can claim again tomorrow!");
                            }
                            break;
                            
                        default:
                            sendMessage($chat_id, "Unknown command. Use /start to see available commands.");
                            break;
                    }
                }
                
                $offset = $update['update_id'] + 1;
            }
        }
        
        // Sleep for 1 second to avoid excessive API calls
        sleep(1);
    }
}

// Run the bot
runBot();
?>
