<?php
require_once 'auth.php';
require_once '../db.php';
require_once '../functions.php';

// Initialize GameFunctions
$game = new GameFunctions();

// Handle actions
$action = $_POST['action'] ?? '';
$csrf_token = $_POST['csrf_token'] ?? '';
$success_message = '';
$error_message = '';

if ($action && validateCsrfToken($csrf_token)) {
    try {
        switch ($action) {
            case 'edit_balance':
                $telegram_id = $_POST['telegram_id'] ?? '';
                $new_balance = $_POST['new_balance'] ?? '';
                if ($telegram_id && $new_balance) {
                    $stmt = $game->db->prepare("UPDATE users SET balance = ? WHERE telegram_id = ?");
                    if ($stmt->execute([$new_balance, $telegram_id])) {
                        $success_message = "残高を更新しました。";
                    } else {
                        $error_message = "更新に失敗しました。";
                    }
                }
                break;
                
            case 'ban_user':
                $telegram_id = $_POST['telegram_id'] ?? '';
                if ($telegram_id) {
                    $stmt = $game->db->prepare("UPDATE users SET is_banned = 1 WHERE telegram_id = ?");
                    if ($stmt->execute([$telegram_id])) {
                        $success_message = "ユーザーを禁止しました。";
                    } else {
                        $error_message = "禁止に失敗しました。";
                    }
                }
                break;
                
            case 'unban_user':
                $telegram_id = $_POST['telegram_id'] ?? '';
                if ($telegram_id) {
                    $stmt = $game->db->prepare("UPDATE users SET is_banned = 0 WHERE telegram_id = ?");
                    if ($stmt->execute([$telegram_id])) {
                        $success_message = "ユーザーの禁止を解除しました。";
                    } else {
                        $error_message = "解除に失敗しました。";
                    }
                }
                break;
                
            case 'approve_withdraw':
                $withdraw_id = $_POST['withdraw_id'] ?? '';
                if ($withdraw_id) {
                    $stmt = $game->db->prepare("UPDATE withdraws SET status = 'completed' WHERE id = ?");
                    if ($stmt->execute([$withdraw_id])) {
                        $success_message = "引き出しを承認しました。";
                    } else {
                        $error_message = "承認に失敗しました。";
                    }
                }
                break;
                
            case 'reject_withdraw':
                $withdraw_id = $_POST['withdraw_id'] ?? '';
                if ($withdraw_id) {
                    $stmt = $game->db->prepare("UPDATE withdraws SET status = 'rejected' WHERE id = ?");
                    if ($stmt->execute([$withdraw_id])) {
                        $success_message = "引き出しを拒否しました。";
                    } else {
                        $error_message = "拒否に失敗しました。";
                    }
                }
                break;
        }
    } catch (Exception $e) {
        $error_message = "エラーが発生しました: " . $e->getMessage();
    }
}

// Get user list
$stmt = $game->db->query("SELECT telegram_id, username, first_name, balance, is_banned 
                         FROM users 
                         ORDER BY balance DESC");
$users = $stmt->fetchAll();

// Get pending withdrawals
$stmt = $game->db->query("SELECT * FROM withdraws WHERE status = 'pending' ORDER BY created_at DESC");
$pending_withdrawals = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>管理者ダッシュボード - Rich Animals Bot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        .dashboard-container {
            max-width: 1200px;
            margin: 2rem auto;
            padding: 2rem;
            background: white;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .user-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
        }
        .withdraw-card {
            background: #fff;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
        }
        .action-btn {
            margin-right: 0.5rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="dashboard-container">
            <h1 class="mb-4">管理者ダッシュボード</h1>
            
            <?php if ($success_message): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($success_message); ?></div>
            <?php endif; ?>
            
            <?php if ($error_message): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error_message); ?></div>
            <?php endif; ?>

            <!-- User Management -->
            <div class="card mb-4">
                <div class="card-header">
                    <h3 class="mb-0">ユーザー管理</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php foreach ($users as $user): ?>
                            <div class="col-md-4 mb-3">
                                <div class="user-card">
                                    <h5>
                                        <?php echo htmlspecialchars($user['username'] ? '@' . $user['username'] : $user['first_name']); ?>
                                        <?php if ($user['is_banned']): ?>
                                            <span class="text-danger">(禁止)</span>
                                        <?php endif; ?>
                                    </h5>
                                    <p class="mb-2">
                                        <i class="bi bi-currency-dollar"></i> 残高: $<?php echo number_format($user['balance'], 2); ?>
                                    </p>
                                    <form method="POST" class="mb-2">
                                        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(generateCsrfToken()); ?>">
                                        <input type="hidden" name="telegram_id" value="<?php echo htmlspecialchars($user['telegram_id']); ?>">
                                        <div class="input-group">
                                            <input type="number" class="form-control" name="new_balance" placeholder="新しい残高">
                                            <button type="submit" name="action" value="edit_balance" class="btn btn-primary">
                                                残高更新
                                            </button>
                                        </div>
                                    </form>
                                    <form method="POST" class="d-inline">
                                        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(generateCsrfToken()); ?>">
                                        <input type="hidden" name="telegram_id" value="<?php echo htmlspecialchars($user['telegram_id']); ?>">
                                        <button type="submit" name="action" 
                                                value="<?php echo $user['is_banned'] ? 'unban_user' : 'ban_user'; ?>" 
                                                class="btn btn-<?php echo $user['is_banned'] ? 'success' : 'danger'; ?>">
                                            <?php echo $user['is_banned'] ? '禁止解除' : '禁止'; ?>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Withdrawal Management -->
            <div class="card">
                <div class="card-header">
                    <h3 class="mb-0">引き出しリクエスト</h3>
                </div>
                <div class="card-body">
                    <?php if (empty($pending_withdrawals)): ?>
                        <p class="text-muted">現在、承認待ちの引き出しリクエストはありません。</p>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>ユーザー</th>
                                        <th>金額</th>
                                        <th>支払い方法</th>
                                        <th>詳細</th>
                                        <th>作成日時</th>
                                        <th>アクション</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($pending_withdrawals as $withdraw): ?>
                                        <tr>
                                            <td>
                                                <?php 
                                                $user = $game->getUser($withdraw['user_id']);
                                                echo htmlspecialchars($user['username'] ? '@' . $user['username'] : $user['first_name']);
                                                ?>
                                            </td>
                                            <td>$<?php echo number_format($withdraw['amount'], 2); ?></td>
                                            <td><?php echo htmlspecialchars($withdraw['payment_method']); ?></td>
                                            <td><?php echo htmlspecialchars($withdraw['details']); ?></td>
                                            <td><?php echo date('Y-m-d H:i', strtotime($withdraw['created_at'])); ?></td>
                                            <td>
                                                <form method="POST" class="d-inline">
                                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(generateCsrfToken()); ?>">
                                                    <input type="hidden" name="withdraw_id" value="<?php echo htmlspecialchars($withdraw['id']); ?>">
                                                    <button type="submit" name="action" value="approve_withdraw" class="btn btn-success btn-sm">
                                                        承認
                                                    </button>
                                                </form>
                                                <form method="POST" class="d-inline">
                                                    <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars(generateCsrfToken()); ?>">
                                                    <input type="hidden" name="withdraw_id" value="<?php echo htmlspecialchars($withdraw['id']); ?>">
                                                    <button type="submit" name="action" value="reject_withdraw" class="btn btn-danger btn-sm">
                                                        拒否
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
