<?php
session_start();
require_once 'config.php';

function checkAdminAuth() {
    if (!isset($_SESSION[ADMIN_SESSION_KEY]) || !$_SESSION[ADMIN_SESSION_KEY]) {
        header('Location: login.php');
        exit();
    }
}

function generateCsrfToken() {
    if (!isset($_SESSION[ADMIN_TOKEN_KEY])) {
        $_SESSION[ADMIN_TOKEN_KEY] = bin2hex(random_bytes(32));
    }
    return $_SESSION[ADMIN_TOKEN_KEY];
}

function validateCsrfToken($token) {
    return isset($_SESSION[ADMIN_TOKEN_KEY]) && hash_equals($_SESSION[ADMIN_TOKEN_KEY], $token);
}
?>
