<?php
/**
 * Telegram Bot Web Admin Panel - Dashboard
 */

require_once '../config.php';
require_once '../bot_functions.php';
require_once 'auth_check.php';

// Get user statistics
$pdo = getDBConnection();
$stats = [
    'total_users' => 0,
    'categories' => [],
    'recent_messages' => [],
    'active_today' => 0
];

// Get total users and category breakdown
$stmt = $pdo->query("
    SELECT c.name, COUNT(u.id) as count
    FROM categories c
    LEFT JOIN users u ON c.id = u.category_id
    WHERE u.is_active = 1
    GROUP BY c.id, c.name
    ORDER BY c.name
");
$stats['categories'] = $stmt->fetchAll();

// Calculate total users
$stats['total_users'] = array_sum(array_column($stats['categories'], 'count'));

// Get active users today
$stmt = $pdo->query("
    SELECT COUNT(*) FROM users 
    WHERE last_activity >= CURDATE() 
    AND is_active = 1
");
$stats['active_today'] = $stmt->fetchColumn();

// Get recent messages
$stmt = $pdo->query("
    SELECT m.*, COUNT(ml.id) as delivered_count,
           (SELECT COUNT(*) FROM message_logs WHERE message_id = m.id AND status = 'failed') as failed_count
    FROM messages m
    LEFT JOIN message_logs ml ON m.id = ml.message_id AND ml.status = 'sent'
    GROUP BY m.id
    ORDER BY m.created_at DESC
    LIMIT 5
");
$stats['recent_messages'] = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bot Admin Panel - Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        .sidebar {
            position: fixed;
            top: 0;
            bottom: 0;
            left: 0;
            z-index: 100;
            padding: 48px 0 0;
            box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
            background: #f8f9fa;
        }
        .sidebar-sticky {
            position: relative;
            top: 0;
            height: calc(100vh - 48px);
            padding-top: .5rem;
            overflow-x: hidden;
            overflow-y: auto;
        }
        .main {
            padding-top: 48px;
        }
        .stat-card {
            border-radius: 15px;
            border: none;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark bg-primary fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="#">📱 Bot Admin Panel</a>
            <div class="d-flex">
                <span class="navbar-text me-3">
                    Welcome, <?php echo htmlspecialchars($_SESSION['admin_username']); ?>
                </span>
                <a href="logout.php" class="btn btn-outline-light btn-sm">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            <nav class="col-md-3 col-lg-2 d-md-block sidebar">
                <div class="sidebar-sticky">
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link active" href="dashboard.php">
                                <i class="bi bi-speedometer2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="users.php">
                                <i class="bi bi-people"></i> Users
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="send_message.php">
                                <i class="bi bi-send"></i> Send Message
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="categories.php">
                                <i class="bi bi-folder"></i> Categories
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="message_logs.php">
                                <i class="bi bi-list-ul"></i> Logs
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 main">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">Dashboard</h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <a href="send_message.php" class="btn btn-primary">
                            <i class="bi bi-send"></i> New Message
                        </a>
                    </div>
                </div>

                <!-- Statistics Cards -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card stat-card bg-primary text-white">
                            <div class="card-body">
                                <h5 class="card-title">Total Users</h5>
                                <h2><?php echo number_format($stats['total_users']); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-success text-white">
                            <div class="card-body">
                                <h5 class="card-title">Active Today</h5>
                                <h2><?php echo number_format($stats['active_today']); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-info text-white">
                            <div class="card-body">
                                <h5 class="card-title">Categories</h5>
                                <h2><?php echo count($stats['categories']); ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card stat-card bg-warning text-dark">
                            <div class="card-body">
                                <h5 class="card-title">Messages Today</h5>
                                <h2><?php 
                                    $stmt = $pdo->query("SELECT COUNT(*) FROM messages WHERE DATE(created_at) = CURDATE()");
                                    echo $stmt->fetchColumn();
                                ?></h2>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Category Breakdown -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Users by Category</h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Category</th>
                                                <th>Users</th>
                                                <th>Percentage</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($stats['categories'] as $category): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($category['name']); ?></td>
                                                    <td><?php echo number_format($category['count']); ?></td>
                                                    <td>
                                                        <?php 
                                                        if ($stats['total_users'] > 0) {
                                                            $percentage = ($category['count'] / $stats['total_users']) * 100;
                                                            echo number_format($percentage, 1) . '%';
                                                        } else {
                                                            echo '0%';
                                                        }
                                                        ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Recent Messages</h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Title</th>
                                                <th>Sent</th>
                                                <th>Failed</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($stats['recent_messages'] as $message): ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($message['title']); ?></td>
                                                    <td class="text-success">
                                                        <?php echo number_format($message['delivered_count']); ?>
                                                    </td>
                                                    <td class="text-danger">
                                                        <?php echo number_format($message['failed_count']); ?>
                                                    </td>
                                                    <td>
                                                        <?php echo date('Y-m-d H:i', strtotime($message['created_at'])); ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</body>
</html>