<?php
/**
 * Telegram Bot Configuration File
 * Generated by installer on <?php echo date('Y-m-d H:i:s'); ?>
 */

// Installation Status
define('INSTALLATION_COMPLETED', true);

// Database Configuration
define('DB_TYPE', '{{DB_TYPE}}');
<?php if (DB_TYPE === 'mysql'): ?>
define('DB_HOST', '{{DB_HOST}}');
define('DB_NAME', '{{DB_NAME}}');
define('DB_USER', '{{DB_USER}}');
define('DB_PASS', '{{DB_PASS}}');
<?php else: ?>
define('DB_FILE', __DIR__ . '/{{DB_NAME}}');
<?php endif; ?>

// Telegram Bot Configuration
define('BOT_TOKEN', '{{BOT_TOKEN}}');
define('WEBHOOK_URL', '{{WEBHOOK_URL}}');

// Admin Configuration
define('ADMIN_IDS', [
    {{ADMIN_TELEGRAM_ID}} // Primary admin
]);

// File Upload Configuration
define('UPLOAD_DIR', 'uploads/');
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB

// Database Connection Function
function getDBConnection() {
    try {
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ];
        
        if (DB_TYPE === 'sqlite') {
            $pdo = new PDO('sqlite:' . DB_FILE);
            $pdo->exec('PRAGMA foreign_keys = ON;');
        } else {
            $pdo = new PDO(
                'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4',
                DB_USER,
                DB_PASS,
                $options
            );
        }
        
        return $pdo;
    } catch (PDOException $e) {
        error_log('Database connection failed: ' . $e->getMessage());
        die('Database connection failed');
    }
}

// Check if user is admin
function isAdmin($telegram_id) {
    return in_array($telegram_id, ADMIN_IDS);
}

// Create uploads directory if it doesn't exist
if (!file_exists(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}