<?php
/**
 * Telegram Message Sender Bot Configuration
 * 
 * SETUP INSTRUCTIONS:
 * 1. Create a new bot via @BotFather on Telegram
 * 2. Get your bot token and replace BOT_TOKEN below
 * 3. Set up MySQL database using db.sql
 * 4. Update database credentials below
 * 5. Add your Telegram ID to ADMIN_IDS array
 * 6. Upload files to your web server
 * 7. Run setWebhook.php to set webhook URL
 */

// Telegram Bot Configuration
define('BOT_TOKEN', 'YOUR_BOT_TOKEN_HERE');
define('WEBHOOK_URL', 'https://yourdomain.com/bot.php');

// Database Configuration
define('DB_TYPE', 'sqlite'); // or 'mysql' for MySQL
define('DB_FILE', __DIR__ . '/bot.db'); // SQLite database file
// MySQL configuration (when DB_TYPE is 'mysql')
define('DB_HOST', 'localhost');
define('DB_NAME', 'telegram_bot');
define('DB_USER', 'your_db_username');
define('DB_PASS', 'your_db_password');

// Admin Configuration (Add your Telegram IDs here)
define('ADMIN_IDS', [
    123456789,  // Replace with your Telegram ID
    987654321   // Add more admin IDs as needed
]);

// Web Admin Panel Configuration
define('WEB_ADMIN_USERNAME', 'admin');
define('WEB_ADMIN_PASSWORD', 'your_secure_password'); // Change this!

// File Upload Configuration
define('UPLOAD_DIR', 'uploads/');
define('MAX_FILE_SIZE', 5 * 1024 * 1024); // 5MB

// Telegram API Base URL
define('TELEGRAM_API', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');

// Database Connection Function
function getDBConnection() {
    try {
        // Check available PDO drivers
        $available_drivers = PDO::getAvailableDrivers();
        error_log("Available PDO drivers: " . implode(", ", $available_drivers));
        
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ];
        
        if (DB_TYPE === 'sqlite') {
            if (!in_array('sqlite', $available_drivers)) {
                throw new Exception("SQLite PDO driver not available. Available drivers: " . implode(", ", $available_drivers));
            }
            $dsn = "sqlite:" . DB_FILE;
            $pdo = new PDO($dsn);
            
            // Enable foreign keys for SQLite
            $pdo->exec('PRAGMA foreign_keys = ON;');
        } else {
            if (!in_array('mysql', $available_drivers)) {
                throw new Exception("MySQL PDO driver not available. Available drivers: " . implode(", ", $available_drivers));
            }
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        }
        
        error_log("Database connection successful");
        return $pdo;
        
    } catch (PDOException $e) {
        error_log("PDO Error: " . $e->getMessage());
        throw new Exception("Database connection failed: " . $e->getMessage());
    } catch (Exception $e) {
        error_log("General Error: " . $e->getMessage());
        throw $e;
    }
}

// Check if user is admin
function isAdmin($telegram_id) {
    return in_array($telegram_id, ADMIN_IDS);
}

// Create uploads directory if it doesn't exist
if (!file_exists(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}
?>
